#!/usr/local/bin/perl -w

if ($#ARGV >= 0 && $ARGV[0] =~ /s/) {
    $subs = 1;   # display subchapters
    $button = '<CENTER>[<A HREF="index.cgi?c">Display Titles Only</A>]</CENTER>';
} else {
    $subs = 0;   # display titles only
    $button = '<CENTER>[<A HREF="index.cgi?s">Display Subchapters</A>]</CENTER>';
}

print << "__EOD__";
Content-type: text/html

<HTML>
<HEAD>
<TITLE>SWISH 1.2.1 Manuals</TITLE>
<META NAME="description" CONTENT="SWISH Manuals">
<META NAME="keywords" CONTENT="SWISH,index,search engine,WAIS,W3,WWW,web,Simple Web Indexing System for Humans,manuals,manual,docs,documentation,toc,table of contents,contents">
</HEAD>

<BODY BGCOLOR="#ffffff" TEXT="#000000"
     LINK="#ff0000" ALINK="#00cc00" VLINK="#cc0000">

<BLOCKQUOTE>
<H1><IMG SRC="/icons/swish.gif" ALT="" WIDTH=60 HEIGHT=60 BORDER=0>SWISH
    1.2.1 Manual</H1>

<FONT SIZE=2>
<HR>
<B>Note for pre 1.1 users:</B>
<I>SWISH has changed considerably since version 1.0!
<B>The format is different and configuration variables have changed.</B>
1.0 SWISH users should reindex their files using version 1.2.1.
Please read the <A HREF="c-changes.html">list
of changes</A> since version 1.0.</I>
<HR>

$button

</FONT>

<H2>Contents</H2>

<OL>
__EOD__

foreach $f ( `ls [0-9]*-*.html` ) {
    $f =~ s/\n//;
    if ($subs == 0) {
        $chap = "$f:" . `grep '^<TITLE>' $f`;
    } else {
        $chap = "$f:" . `egrep '^<TITLE>|<H2><A NAME' $f`;
    }
    $chap =~ s,^,<LI><A HREF=",;
    $chap =~ s,:<TITLE>,">,;
    $chap =~ s,SWISH 1.2.1,,;
    $chap =~ s,SWISH,,;
    $chap =~ s,TITLE>,A>,;
    if ($subs == 1 && $chap =~ /<H2>/) {
        $chap =~ s,<H2>,<BR>\&nbsp;&nbsp;&nbsp;&nbsp;,g;
        $chap =~ s,</H2>,,g;
        $chap =~ s,<A NAME=",<A HREF="$f#,g;
    }
    print "$chap<BR>\n";
}

print << "__EOD__";
</OL>

<H2>Appendices</H2>
<OL TYPE="A">
__EOD__

foreach $app ( `grep '^<TITLE>' [a-z]-*.html` ) {
    $app =~ s,^,<LI><A HREF=",;
    $app =~s,:<TITLE>,">,;
    $app =~ s,TITLE>,A>,;
    $app =~s,App. . - ,,;
    $app =~s,SWISH 1.2.1,,;
    $app =~s,SWISH,,;
    print "$app<BR>\n";
}

print << "__EOD__";
</OL>

<FONT SIZE=2>
$button
<HR>
Thanks to all those who contributed input into swish.
As always, patches, improvements, suggestions, and corrections
are gratefully accepted. Send 'em all to <B>Miles O'Neal</B> at
<A HREF="mailto:meo\@rru.com"><I>meo\@rru.com</I></A>.

<HR>
<I>Last update: 17/Aug/1998</I>
</FONT>
</BLOCKQUOTE>

</BODY>
</HTML>
__EOD__
