#if ! defined(_config_h_)
#   define _config_h_ 1
/*
** Copyright (C) 1995, Enterprise Integration Technologies Corp.
** All Rights Reserved.
** Kevin Hughes, kevinh@eit.com
** 3/11/94
 *
 * Copyright 1995-1998 by Miles O'Neal, Austin, TX, USA.
 * 
 * All Rights Reserved, except as noted herein.
 * 
 * This software may be redistributed in any fashion you like, with only
 * the following limitations.
 * 
 *    1) You must credit the authors in the source code and accompanying
 *       documentation.
 * 
 *    2) You may not use any of the names of the authors or their employers
 *       in any associated advertising without explicit permission from the
 *       parties you wish to name.  Finding and contacting them is up to you.
 * 
 *    3) This copyright must be provided along with the documentation or
 *       code.
 * 
 *    4) The accompanying disclaimer must must be provided along with the
 *       documentation or code.
 * 
 *    5) You must also follow the terms of the enclosed LICENSE-EIT.
 * 
 * If you can actually use this to make money, more power to you.  Just
 * realize that the swish author is dedicated to keeping good, robust,
 * useful code freely available to the public, and that philosophy applies
 * to this package as well.
 * 
 * 
 * WARRANTY & DISCLAIMER
 * 
 * This software is presented as is, with no warranties expressed
 * or implied, including implied warranties of merchantability and
 * fitness.  In no event shall the authors, their institutions, or
 * any subsequent distributors be liable for any special, direct,
 * indirect or consequential damages whatsoever resulting from loss
 * of use, data or profits, whether in an action of contract,
 * negligence or other tortious action, arising out of or in connection
 * with the use or performance of this software. In other words, if
 * you don't like it, don't use it!
 * 
 * Bugs and feature requests, complaints, and so forth, brought to the
 * swish author's attention, will be considered.  Any modifications will
 * be made at the sole discretion of the author.
 * 
 * 
 * AUTHOR
 * 
 * Miles O'Neal
 * meo@rru.com
 * 
 * [Non-obscene suggestions for improvement to this copyright and disclaimer
 * are always welcome.  The intent is to keep control, simply so that nobody
 * else takes control.  This document should be concise and user-friendly.]
 * 
*/


/*
** SWISH Default Configuration File
**
** Miles O'Neal, meo@rru.com    21 Aug 1998
** Kevin Hughes, kevinh@eit.com  3/11/94
**
** The following are user-definable options that you can change
** to fine-tune SWISH's default options.
*/

/* #define NEXTSTEP */

/* You may need to define this if compiling on a NeXTstep machine.
*/

#define INDEXPERMS 0664

/* After SWISH generates an index file, it changes the permissions
** of the file to this mode. Change to the mode you like
** (note that it must be an octal number). If you don't want
** permissions to be changed for you, comment out this line.
*/

#define PLIMIT 80
#define FLIMIT 256

/* SWISH uses these parameters to automatically mark words as
** being too common while indexing. For instance, if I defined PLIMIT
** as 80 and FLIMIT as 256, SWISH would define a common word as
** a word that occurs in over 80% of all indexed files and over
** 256 files. Making these numbers lower will most likely make your
** index files smaller. Making PLIMIT and FLIMIT small will also
** ensure that searching consumes only so much CPU resources.
*/

#define VERBOSE 0

/* You can define VERBOSE to be a number from 0 to 3.
**   0 : totally silent
**   1 : summary information
**   2 : lists directories traversed
**   3 : lists files indexed and words found per file
*/

#if ! defined(MAXHITS)
#   define MAXHITS 50
#endif

/* MAXHITS is the default maximum number of results to return from a search.
*/

#define DEFAULT_RULE AND_RULE

/* If a list of search words is specified without booleans,
** SWISH will assume they are connected by a default rule.
** This can be AND_RULE or OR_RULE.
*/

#define TITLETOPLINES 8

/* This is how many lines deep SWISH will look into an HTML file to
** attempt to find a <TITLE> tag.
*/

#define EMPHASIZECOMMENTS 0
#define EMPHASIZEMETATAGS 1

/* Normally, words within HTML comments and META tags are not assigned
** a higher relevance rank. If you're including keywords in comments,
** define this as 1 so matching results will rise to the top of search
** results.
*/

#define IGNORE_CASE 1

/* By default, swish ignores case.  Set this to 0 to make swish
** case sensitive.
*/

#define MINWORDLIMIT 3 /* originally 3 */

/* This is the minimum length of a word. Anything shorter will not
** be indexed.
*/

#define MAXWORDLIMIT 20 /* originally 30 */

/* This is the maximum length of a word. Anything longer will not
** be indexed.
*/

#define ASCIIENTITIES 1

/* If defined as 1, all entities in search words and indexed
** words will be converted to an ASCII equivalent. For instance,
** with this feature you can index the word "resum&eacute;" or
** "resum&#233;" and it will be indexed as the word "resume".
** If defined as 0, only numerical entities will be converted
** to named entities, if they exist.
*/

#define IGNOREALLV 1 /* originally 0 */
#define IGNOREALLC 1 /* originally 0 */
#define IGNOREALLN 1 /* originally 0 */

/* If IGNOREALLV is 1, words containing all vowels won't be indexed.
** If IGNOREALLC is 1, words containing all consonants won't be indexed.
** If IGNOREALLN is 1, words containing all digits won't be indexed.
** Define as 0 to allow words with consistent characters.
** Vowels are defined as "aeiou", digits are "0123456789".
*/

#define IGNOREROWV 3 /* originally 4 */
#define IGNOREROWC 4 /* originally 5 */
#define IGNOREROWN 3 /* originally 4 */

/* IGNOREROWV is the maximum number of consecutive vowels a word can have.
** IGNOREROWC is the maximum number of consecutive consonants a word can have.
** IGNOREROWN is the maximum number of consecutive digits a word can have.
** Vowels are defined as "aeiou", digits are "0123456789".
*/

#define IGNORESAME 3

/* IGNORESAME is the maximum times a character can repeat in a word.
*/

#define WORDCHARS "abcdefghijklmnopqrstuvwxyz&-+_#;0123456789'"

/* WORDCHARS is a string of characters which SWISH permits to
** be in words. Any strings which do not include these characters
** will not be indexed. You can choose from any character in
** the following string:
**
** abcdefghijklmnopqrstuvwxyz&#;0123456789_\|/-+=?!@$%^'\"`~,.[]{}()
**
** Note that if you omit "0123456789&#;" you will not be able to
** index HTML entities. DO NOT use the asterisk (*), lesser than
** and greater than signs (<), (>), or colon (:).
**
** Including any of these four characters may cause funny things to happen.
** If you have a pressing need to index 8-bit characters, please contact
** me for possible user testing in the future.
**
** Also note that if you specify the backslash character (\) or
** double quote (") you need to type a backslash before them to
** make the compiler understand them.
*/

#define BEGINCHARS "abcdefghijklmnopqrstuvwxyz&"

/* Of the characters that you decide can go into words, this is
** a list of characters that words can begin with. It should be
** a subset of (or equal to) WORDCHARS.
*/

#define ENDCHARS "abcdefghijklmnopqrstuvwxyz;0123456789+"

/* This is the same as BEGINCHARS, except you're testing for
** valid characters at the ends of words.
*/

/* Note that if you really want to edit the default stopwords, (words
** that are deemed too common to be indexed) then you can do so in the
** file "swish.h". They don't have to be in alphabetical order.
*/

#define INDEXTAGS 0

/* Normally, all data in tags in HTML files (except for words in
** comments and META tags) is ignored. If you want to index HTML
** files with the text within tags and all, define this to be 1
** and not 0.
*/

#define DOCURL "http://www.netads.com/Doc/swish/"

/* This is the URL for the docs.  You can leave it as is, or if you
** install the docs, you may want to use that URL for faster access.
*/
#endif /* _config_h_ */
