/*
** Copyright (C) 1995, Enterprise Integration Technologies Corp.    
** All Rights Reserved.
** Kevin Hughes, kevinh@eit.com 
** 3/11/94
 *
 * Copyright 1995-1998 by Miles O'Neal, Austin, TX, USA.
 * 
 * All Rights Reserved, except as noted herein.
 * 
 * This software may be redistributed in any fashion you like, with only
 * the following limitations.
 * 
 *    1) You must credit the authors in the source code and accompanying
 *       documentation.
 * 
 *    2) You may not use any of the names of the authors or their employers
 *       in any associated advertising without explicit permission from the
 *       parties you wish to name.  Finding and contacting them is up to you.
 * 
 *    3) This copyright must be provided along with the documentation or
 *       code.
 * 
 *    4) The accompanying disclaimer must must be provided along with the
 *       documentation or code.
 * 
 *    5) You must also follow the terms of the enclosed LICENSE-EIT.
 * 
 * If you can actually use this to make money, more power to you.  Just
 * realize that the swish author is dedicated to keeping good, robust,
 * useful code freely available to the public, and that philosophy applies
 * to this package as well.
 * 
 * 
 * WARRANTY & DISCLAIMER
 * 
 * This software is presented as is, with no warranties expressed
 * or implied, including implied warranties of merchantability and
 * fitness.  In no event shall the authors, their institutions, or
 * any subsequent distributors be liable for any special, direct,
 * indirect or consequential damages whatsoever resulting from loss
 * of use, data or profits, whether in an action of contract,
 * negligence or other tortious action, arising out of or in connection
 * with the use or performance of this software. In other words, if
 * you don't like it, don't use it!
 * 
 * Bugs and feature requests, complaints, and so forth, brought to the
 * swish author's attention, will be considered.  Any modifications will
 * be made at the sole discretion of the author.
 * 
 * 
 * AUTHOR
 * 
 * Miles O'Neal
 * meo@rru.com
 * 
 * [Non-obscene suggestions for improvement to this copyright and disclaimer
 * are always welcome.  The intent is to keep control, simply so that nobody
 * else takes control.  This document should be concise and user-friendly.]
 * 
*/

#include "swish.h"
#include "file.h"
#include "error.h"
#include "hash.h"
#include "list.h"
#include "string.h"

/* Is a file a directory?
*/

int isdirectory(path)
    char *path;
{
    struct stat stbuf;

    if (stat(path, &stbuf))
        return 0;
    return ((stbuf.st_mode & S_IFMT) == S_IFDIR) ? 1 : 0;
}

/* Is a file a regular file?
*/

int isfile(path)
    char *path;
{
    struct stat stbuf;

    if (stat(path, &stbuf))
        return 0;
    return ((stbuf.st_mode & S_IFMT) == S_IFREG) ? 1 : 0;
}

/* Is a file a link?
*/

int islink(path)
char *path;
{
    struct stat stbuf;

    if (lstat(path, &stbuf))
        return 0;
    return ((stbuf.st_mode & S_IFLNK) == S_IFLNK) ? 1 : 0;
}

/* Get the size, in bytes, of a file.
** Return -1 if there's a problem.
*/

int getsize(path)
    char *path;
{
    struct stat stbuf;

    if (stat(path, &stbuf))
        return -1;
    return stbuf.st_size;
}

/* Reads the configuration file and puts all the right options
** in the right variables and structures.
*/

void getdefaults(conffile, hasdir, hasindex, plimit, flimit, hasverbose,
  hasmaxhits, hasemphcomm, hasemphmeta)
    char *conffile;
    int *hasdir;
    int *hasindex;
    int *plimit;
    int *flimit;
    int hasverbose;
    int hasmaxhits;
    int hasemphcomm;
    int hasemphmeta;
{
    int skiplen, gotdir, gotindex;
    char *c, line[MAXSTRLEN], value[MAXSTRLEN];
    FILE *fp;

    gotdir = gotindex = 0;

    if ((fp = fopen(conffile, "r")) == NULL) {
        sprintf(errorstr,
            "Couldn't open the configuration file \"%s\".", conffile);
        progerr(errorstr);
    }
    while (fgets(line, MAXSTRLEN, fp) != NULL) {
        if (line[0] == '#' || line[0] == '\n')
            continue;
        if (NULL != (c = (char *) lstrstr(line, "IndexDir"))) {
            c += strlen("IndexDir");
            while (!*hasdir) {
                strcpy(value, (char *) getword(c, &skiplen));
                if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                    break;
                } else {
                    c += skiplen;
                    dirlist = (struct swline *) addswline(dirlist, value);
                    gotdir = 1;
                }
            }
        } else if (NULL != (c = (char *) lstrstr(line, "IndexFile"))) {
            c += strlen("IndexFile");
            while (!*hasindex) {
                strcpy(value, (char *) getword(c, &skiplen));
                if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                    break;
                } else {
                    c += skiplen;
                    indexlist = (struct swline *) addswline(indexlist, value);
                    gotindex = 1;
                }
            }

        /* IndexVerbose is supported for backwards compatibility */

        } else if (NULL != (c = (char *) lstrstr(line, "IndexVerbose"))) {
            c += strlen("IndexVerbose");
            strcpy(value, (char *) getword(c, &skiplen));
            verbose = (lstrstr(value, "yes")) ? 3 : 0;
        } else if (NULL != (c = (char *) lstrstr(line, "IndexReport"))) {
            c += strlen("IndexReport");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                if (!hasverbose)
                    verbose = atoi(value);
            }
        } else if (NULL != (c = (char *) lstrstr(line, "MaxHits"))) {
            c += strlen("MaxHits");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                if (!hasmaxhits)
                    maxhits = atoi(value);
            }
        } else if (NULL != (c = (char *) lstrstr(line, "TitleTopLines"))) {
            c += strlen("TitleTopLines");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                titletoplines = atoi(value);
            }
        } else if (NULL != (c = (char *) lstrstr(line, "MinWordLimit"))) {
            c += strlen("MinWordLimit");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                minwordlimit = atoi(value);
            }
        } else if (NULL != (c = (char *) lstrstr(line, "MaxWordLimit"))) {
            c += strlen("MaxWordLimit");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                maxwordlimit = atoi(value);
            }

        } else if (NULL != (c = (char *) lstrstr(line, "IgnoreAllV"))) {
            c += strlen("IgnoreAllV");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                ignoreallv = atoi(value);
            }
        } else if (NULL != (c = (char *) lstrstr(line, "IgnoreAllC"))) {
            c += strlen("IgnoreAllC");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                ignoreallc = atoi(value);
            }
        } else if (NULL != (c = (char *) lstrstr(line, "IgnoreAllN"))) {
            c += strlen("IgnoreAllN");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                ignorealln = atoi(value);
            }

        } else if (NULL != (c = (char *) lstrstr(line, "IgnoreRowV"))) {
            c += strlen("IgnoreRowV");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                ignorerowv = atoi(value);
            }
        } else if (NULL != (c = (char *) lstrstr(line, "IgnoreRowC"))) {
            c += strlen("IgnoreRowC");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                ignorerowc = atoi(value);
            }

        } else if (NULL != (c = (char *) lstrstr(line, "IgnoreSame"))) {
            c += strlen("IgnoreSame");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                ignoresame = atoi(value);
            }
        } else if (NULL != (c = (char *) lstrstr(line, "IgnoreRowN"))) {
            c += strlen("IgnoreRowN");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                ignorerown = atoi(value);
            }

        } else if (NULL != (c = (char *) lstrstr(line, "IgnoreAllV"))) {
            c += strlen("IgnoreAllV");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                ignoreallv = atoi(value);
            }
        } else if (NULL != (c = (char *) lstrstr(line, "DefaultRule"))) {
            c += strlen("DefaultRule");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                char *s;
                for (s = &(value[0]); *s != '\0'; s++)
                    *s = tolower(*s);
                c += skiplen;
                if (! strcmp(value, "and")) {
                    default_rule = AND_RULE;
                } else if (! strcmp(value, "or")) {
                    default_rule = OR_RULE;
                } else {
                    fprintf(stderr,
                        "Bad configuration value for DefaultRule: %s - using default (%s)\n",
                        value, (default_rule == AND_RULE) ? "and" : "or");
                    fflush(stderr);
                }
            }
        } else if (NULL != (c = (char *) lstrstr(line, "IndexOnly"))) {
            c += strlen("IndexOnly");
            while (1) {
                strcpy(value, (char *) getword(c, &skiplen));
                if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                    break;
                } else {
                    c += skiplen;
                    suffixlist = (struct swline *)
                        addswline(suffixlist, value);
                }
            }
        } else if (NULL != (c = (char *) lstrstr(line, "NoContents"))) {
            c += strlen("NoContents");
            while (1) {
                strcpy(value, (char *) getword(c, &skiplen));
                if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                    break;
                } else {
                    c += skiplen;
                    nocontentslist = (struct swline *)
                        addswline(nocontentslist, value);
                }
            }
        } else if ((c = (char *) lstrstr(line, "pathname contains")) &&
        (char *) lstrstr(line, "FileRules")) {
            c += strlen("pathname contains");
            while (1) {
                strcpy(value, (char *) getword(c, &skiplen));
                if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                    break;
                } else {
                    c += skiplen;
                    pathconlist = (struct swline *)
                        addswline(pathconlist, value);
                }
            }
        } else if ((c = (char *) lstrstr(line, "directory contains")) &&
          (char *) lstrstr(line, "FileRules")) {
            c += strlen("directory contains");
            while (1) {
                strcpy(value, (char *) getword(c, &skiplen));
                if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                    break;
                } else {
                    c += skiplen;
                    dirconlist = (struct swline *)
                        addswline(dirconlist, value);
                }
            }
        } else if ((c = (char *) lstrstr(line, "filename contains")) &&
          (char *) lstrstr(line, "FileRules")) {
            c += strlen("filename contains");
            while (1) {
                strcpy(value, (char *) getword(c, &skiplen));
                if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                    break;
                } else {
                    c += skiplen;
                    fileconlist = (struct swline *)
                        addswline(fileconlist, value);
                }
            }
        } else if ((c = (char *) lstrstr(line, "title contains")) &&
          (char *) lstrstr(line, "FileRules")) {
            c += strlen("title contains");
            while (1) {
                strcpy(value, (char *) getword(c, &skiplen));
                if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                    break;
                } else {
                    c += skiplen;
                    titconlist = (struct swline *)
                        addswline(titconlist, value);
                }
            }
        } else if ((c = (char *) lstrstr(line, "filename is")) &&
          (char *) lstrstr(line, "FileRules")) {
            c += strlen("filename is");
            while (1) {
                strcpy(value, (char *) getword(c, &skiplen));
                if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                    break;
                } else {
                    c += skiplen;
                    fileislist = (struct swline *)
                        addswline(fileislist, value);
                }
            }
        } else if (NULL != (c = (char *) lstrstr(line, "IgnoreWords"))) {
            c += strlen("IgnoreWords");
            while (1) {
                strcpy(value, (char *) getword(c, &skiplen));
                if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                    break;
                } else {
                    c += skiplen;
                    if (lstrstr(value, "SwishDefault"))
                        readdefaultstopwords();
                    else
                        addstophash(value);
                }
            }
        } else if ((c = (char *) lstrstr(line, "IgnoreLimit"))) {
            c += strlen("IgnoreLimit");
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                *plimit = atoi(value);
            }
            strcpy(value, (char *) getword(c, &skiplen));
            if (!skiplen || value[0] == '\0' || value[0] == '\n') {
                continue;
            } else {
                c += skiplen;
                *flimit = atoi(value);
            }
        } else if (NULL != (c = (char *) lstrstr(line, "ReplaceRules"))) {
            int rrerr = 0;
            char *v1 = NULL, *v2 = NULL, *v3 = NULL;
            c += strlen("ReplaceRules");
            strcpy(value, (char *) getword(c, &skiplen));
            if (skiplen && value[0] != '\0' && value[0] != '\n' &&
              (!strncmp(value, "replace", 7) ||
               !strncmp(value, "prepend", 7) ||
               !strncmp(value, "append", 6))) {
                c += skiplen;
                v1 = mystrdup(value);

                strcpy(value, (char *) getword(c, &skiplen));
                if (skiplen && value[0] != '\n') {
                    c += skiplen;
                        if (value[0] != '\0')
                            v2 = mystrdup(value);
                        else
                            rrerr = 1;
                    if (v1[0] == 'r') {
                        strcpy(value, (char *) getword(c, &skiplen));
                        if (skiplen && value[0] != '\n') {
                            c += skiplen;
                            if (value[0] != '\0')
                                v3 = mystrdup(value);
                            else
                                v3 = "";
                        } else {
                            rrerr = 1;
                        }
                    }
                } else {
                    rrerr = 1;
                }
            } else {
                rrerr = 1;
            }
            if (rrerr) {
                fprintf(stderr, "Illegal ReplaceRule:\n");
                fprintf(stderr, line);
                fflush(stderr);
            } else {
                replacelist = (struct swline *)
                    addswline(replacelist, v1);
                replacelist = (struct swline *)
                    addswline(replacelist, v2);
                if (v3)
                    replacelist = (struct swline *)
                        addswline(replacelist, v3);
            }
        } else if (getconfvalue(line, "AsciiEntities", value) != NULL)
            asciientities = (lstrstr(value, "yes")) ? 1 : 0;
        else if (getconfvalue(line, "IndexTags", value) != NULL)
            indextags = (lstrstr(value, "yes")) ? 1 : 0;
        else if (getconfvalue(line, "FollowSymLinks", value) != NULL)
            followsymlinks = (lstrstr(value, "yes")) ? 1 : 0;
        else if (getconfvalue(line, "EmphasizeComments", value) != NULL &&
          hasemphcomm == 0)
            emph_comm = (lstrstr(value, "yes")) ? 1 : 0;
        else if (getconfvalue(line, "EmphasizeMetaTags", value) != NULL &&
          hasemphmeta == 0)
            emph_meta = (lstrstr(value, "yes")) ? 1 : 0;
        else if (getconfvalue(line, "IndexName", value) != NULL)
            strcpy(indexn, value);
        else if (getconfvalue(line, "IndexDescription", value) != NULL)
            strcpy(indexd, value);
        else if (getconfvalue(line, "IndexPointer", value) != NULL)
            strcpy(indexp, value);
        else if (getconfvalue(line, "IndexAdmin", value) != NULL)
            strcpy(indexa, value);
        else if (getconfvalue(line, "DocUrl", value) != NULL)
            strcpy(docurl, value);
    }
    fclose(fp);

    if (gotdir && !(*hasdir))
        *hasdir = 1;
    if (gotindex && !(*hasindex))
        *hasindex = 1;
}
