/*---------------------------- XOHelpBtn.c ----------------------------*/

/*
 *  generic help button for Xt widget-based programs
 *
 *  Author:  Miles O'Neal
 *
 *  Release: 1.0 meo - FCS release
 *
 *  COPYRIGHT 1990, 1991, Miles O'Neal, Austin, TX
 * (originally Systems & Software Solutions, Inc, Marietta, GA)
 *
 *  Permission is hereby granted to use, copy, modify and/or distribute
 *  this software and supporting documentation, for any purpose and
 *  without fee, as long as this copyright notice and disclaimer are
 *  included in all such copies and derived works, and as long as
 *  neither the author's nor the copyright holder's name are used
 *  in publicity or distribution of said software and/or documentation
 *  without prior, written permission.
 *
 *  This software is presented as is, with no warranties expressed or
 *  implied, including implied warranties of merchantability and
 *  fitness. In no event shall the author be liable for any special,
 *  direct, indirect or consequential damages whatsoever resulting
 *  from loss of use, data or profits, whether in an action of
 *  contract, negligence or other tortious action, arising out of
 *  or in connection with the use or performance of this software.
 *  In other words, you are on your own. If you don't like it, don't
 *  use it!
 */
static char _SSS_XOHelpBtn_copyright[] =
    "XOHelpBtn 1.0 Copyright 1990, 1991, Miles O'Neal, Austin, TX";


#include "libXO.h"

#include <X11/Xos.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#if XT_REVISION <= 3
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Text.h>
#include <X11/AsciiText.h>
#else
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h>
#endif

#if XT_REVISION == 2 || X_REVISION == 3
#define ASCII_WIDGET_CLASS asciiStringWidgetClass
#else
#define ASCII_WIDGET_CLASS asciiTextWidgetClass
#endif

void helpDoneCB();
Arg _HTArg[] = {
    {XtNstring,		(XtArgVal) "No help available..."},
};

Arg _HPArg[] = {			/* Help Popup shell defs */
    {XtNlabel, (XtArgVal) NULL},
    {XtNvalue, (XtArgVal) NULL},
    {XtNx, (XtArgVal) 0},
    {XtNy, (XtArgVal) 0},
};

Arg _HBArg[] = {			/* Help box widget defs */
    {XtNlabel, (XtArgVal) NULL},
    {XtNvalue, (XtArgVal) NULL},
};

Arg _HDBArg[] = {			/* Help Done button widget defs */
    {XtNlabel, (XtArgVal) "Done"},
};

static Widget helpPopup = NULL,
    helpBox,
    helpText,
    helpButton;

/*
 *  User pressed Help button - help callback
 *
 *  If the popup doesn't exist, attempt to create it all. If any of
 *  the create fails, we give up on this operation. Otherwise, we
 *  pop it up. If it does exist, we pop it down, then back up. The
 *  extra popdown is in case it's hidden.
 *
 *  Note that the popup shell may not be manageable by non-iC3M window
 *  managers - ie, movable, iconifiable, etc).
 */
void
HelpCallback (w, call_data, event)

Widget w;
caddr_t call_data;
XEvent *event;
{
    if (!helpPopup) {
	_HPArg[2].value = (event ? event->xbutton.x_root - 15 : 100);
	_HPArg[3].value = (event ? event->xbutton.y_root - 15 : 100);
	if (!(helpPopup = XtCreatePopupShell ("helpPopup",
	    transientShellWidgetClass, (Widget) call_data,
		_HPArg, XtNumber (_HPArg)))) {
	    return;
	} else {
	    if (!(helpBox = XtCreateManagedWidget ("helpBox",
		boxWidgetClass, helpPopup, _HBArg, XtNumber (_HBArg))))
		    return;
	    if (!(helpText = XtCreateManagedWidget ("helpText",
		ASCII_WIDGET_CLASS, helpBox, _HTArg, XtNumber (_HTArg))))
		    return;
	    if (!(helpButton = XtCreateManagedWidget ("helpDone",
		commandWidgetClass, helpBox, _HDBArg, XtNumber (_HDBArg))))
		    return;
	    XtAddCallback(helpButton, XtNcallback, helpDoneCB, NULL);
	    XtPopup (helpPopup, XtGrabNone);
	}
    } else {
	XtPopdown (helpPopup);
	XtPopup (helpPopup, XtGrabNone);
    }
}



/*
 *  User pressed Help popup's Done button (callback)
 *
 *  Pop down the help popup box.
*/
void
helpDoneCB (w, call_data, event)

Widget w;
caddr_t call_data;
XEvent *event;
{
    if (helpPopup)
	XtPopdown (helpPopup);
}
