/*
 * xdm - display manager daemon
 *
 * HELP-RELATED PORTIONS COPYRIGHT Miles O'Neal, 1992, Austin, TX.
 *
 *  Permission is hereby granted to use, copy, modify and/or distribute
 *  this software and supporting documentation, for any purpose and
 *  without fee, as long as this copyright notice and disclaimer are
 *  included in all such copies and derived works, and as long as
 *  neither the author's nor the copyright holder's name are used
 *  in publicity or distribution of said software and/or documentation
 *  without prior, written permission.
 *
 *  This software is presented as is, with no warranties expressed or
 *  implied, including implied warranties of merchantability and
 *  fitness. In no event shall the author be liable for any special,
 *  direct, indirect or consequential damages whatsoever resulting
 *  from loss of use, data or profits, whether in an action of
 *  contract, negligence or other tortious action, arising out of
 *  or in connection with the use or performance of this software.
 *  In other words, you are on your own. If you don't like it, don't
 *  use it!
 *
 * REMAINDER COPYRIGHT 1988 Massachusetts Institute of Technology.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Keith Packard, MIT X Consortium
 */

/*
 * widget to get username/password
 *
 */

# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Shell.h>

# include <X11/Xaw/Command.h>
# include <X11/Xaw/Form.h>
#ifdef R5
# include <X11/Xaw/Logo.h>
#endif

# include "Login.h"
# include "dm.h"
# include "libXO.h"

extern Display	*dpy;

extern void HelpCallback(), LoginCallback(), ResetCallback(), RestartCallback();
static int zero = 0;
static int one = 1;

static int	done, code;
static char	name[128], password[128];
static XtAppContext	context;
static XtIntervalId	pingTimeout;
static Widget
    toplevel,
	form,
	   login,
	buttons,
	    ok,
	    reset,
	    restart,
	    failsafe,
	    help;
Widget _loginWidget;

extern Arg _HTArg[];
char _helpText[] =
"Login Screen:\n\
\n\
Username  - Enter your username here and\n\
            press the Return or Enter key.\n\
Password  - Enter your password here.\n\
\n\
Then use Mouse Button 1 to select one of the\n\
buttons at the bottom of the panel:\n\
\n\
    Login       - Press this to login after\n\
                  entering username & password.\n\
    Reset       - Press this to reset the\n\
                  username & password fields.\n\
    Restart     - Press this to restart the\n\
                  login session.\n\
    Min Session - Press this to login with a\n\
                  minimal X environment (useful\n\
                  for debugging .Xsession) .\n\
    Help        - How you got here.\n\
\n\
The normal xdm translations also apply.  See\n\
the xdm(n) man page for additional information.";

/*ARGSUSED*/
static void
GreetPingServer (closure, intervalId)
    XtPointer	    closure;
    XtIntervalId    *intervalId;
{
    struct display *d;

    d = (struct display *) closure;
    if (!PingServer (d, XtDisplay (toplevel)))
	SessionPingFailed (d);
    pingTimeout = XtAppAddTimeOut (context, d->pingInterval * 60 * 1000,
				   GreetPingServer, (closure));
}

/*ARGSUSED*/
GreetDone (w, data, status)
    Widget	w;
    LoginData	*data;
    int		status;
{
    Debug ("GreetDone: %s, (password is %d long)\n",
	    data->name, strlen (data->passwd));
    switch (status) {
    case NOTIFY_OK:
	strcpy (name, data->name);
	strcpy (password, data->passwd);
	code = 0;
	done = 1;
	break;
    case NOTIFY_ABORT:
	Debug ("RESERVER_DISPLAY\n");
	code = RESERVER_DISPLAY;
	done = 1;
	break;
    case NOTIFY_RESTART:
	Debug ("REMANAGE_DISPLAY\n");
	code = REMANAGE_DISPLAY;
	done = 1;
	break;
    case NOTIFY_ABORT_DISPLAY:
	Debug ("UNMANAGE_DISPLAY\n");
	code = UNMANAGE_DISPLAY;
	done = 1;
	break;
    }
}

Display *
InitGreet (d)
struct display	*d;
{
    Arg		arglist[10];
    int		i;
    static int	argc;
    Screen		*scrn;
    static char	*argv[] = { "xlogin", 0 };
    Display		*dpy;
    Dimension height, width;

    Debug ("greet %s\n", d->name);
    argc = 1;
    XtToolkitInitialize ();
    context = XtCreateApplicationContext();
    dpy = XtOpenDisplay (context, d->name, "xlogin", "Xlogin", 0,0,
			 &argc, argv);

    if (!dpy)
	return 0;

    RegisterCloseOnFork (ConnectionNumber (dpy));

    SecureDisplay (d, dpy);

    i = 0;
    scrn = DefaultScreenOfDisplay(dpy);
    XtSetArg(arglist[i], XtNscreen, scrn);	i++;
    XtSetArg(arglist[i], XtNargc, argc);	i++;
    XtSetArg(arglist[i], XtNargv, argv);	i++;

    toplevel = XtAppCreateShell ((String) NULL, "Xlogin",
	applicationShellWidgetClass, dpy, arglist, i);
    XtSetMappedWhenManaged(toplevel, FALSE);
    form = XtVaCreateManagedWidget("form", formWidgetClass, toplevel,
	XtNborderWidth, 0,
	NULL);

    i = 0;
    XtSetArg (arglist[i], XtNnotifyDone, GreetDone); i++;
    if (!d->authorize || d->authorizations || !d->authComplain)
    {
	XtSetArg (arglist[i], XtNsecureSession, True); i++;
    }
    XtSetArg(arglist[i], XtNborderWidth, 0); i++;
    login = XtCreateManagedWidget("login", loginWidgetClass, form, arglist, i);
    buttons = XtVaCreateManagedWidget("buttonBox", formWidgetClass, form,
	XtNfromVert, login,
	XtNborderWidth, 0,
	NULL);
    ok = XtVaCreateManagedWidget("ok", commandWidgetClass, buttons,
	XtNfromHoriz, buttons,
	XtNleft, XtRubber,
	NULL);
    reset = XtVaCreateManagedWidget("reset", commandWidgetClass, buttons,
	XtNfromHoriz, ok,
	XtNleft, XtRubber,
	NULL);
    restart = XtVaCreateManagedWidget("restart", commandWidgetClass, buttons,
	XtNfromHoriz, reset,
	XtNleft, XtRubber,
	NULL);
    failsafe = XtVaCreateManagedWidget("failsafe", commandWidgetClass, buttons,
	XtNfromHoriz, restart,
	XtNleft, XtRubber,
	NULL);
    help = XtVaCreateManagedWidget("help", commandWidgetClass, buttons,
	XtNfromHoriz, failsafe,
	XtNleft, XtRubber,
	XtNright, XtRubber,
	NULL);
    XtRealizeWidget (toplevel);
    XSync(XtDisplay(toplevel), FALSE);

    _loginWidget = login;
    XtAddCallback(ok, XtNcallback, LoginCallback, (XtPointer) &zero);
    XtAddCallback(reset, XtNcallback, ResetCallback, (XtPointer) &zero);
    XtAddCallback(restart, XtNcallback, RestartCallback, (XtPointer) &zero);
    XtAddCallback(failsafe, XtNcallback, LoginCallback, (XtPointer) &one);
    _HTArg[0].value = (XtArgVal) _helpText;
    XtAddCallback(help, XtNcallback, HelpCallback, (XtPointer) toplevel);

    i = 0;
    XtSetArg (arglist[i], XtNheight, &height); i++;
    XtSetArg (arglist[i], XtNwidth, &width); i++;
    XtGetValues(toplevel, arglist, i);
    i = 0;
    XtSetArg (arglist[i], XtNy, (HeightOfScreen(scrn) - height) / 2); i++;
    XtSetArg (arglist[i], XtNx, (WidthOfScreen(scrn) - width) / 2); i++;
    XtSetValues(toplevel, arglist, i);
    XtSetMappedWhenManaged(toplevel, TRUE);
    XtMapWidget(toplevel);
    XtGrabKeyboard(login, False, GrabModeAsync, GrabModeAsync, CurrentTime);

    XWarpPointer(dpy, None, RootWindowOfScreen (scrn),
		    0, 0, 0, 0,
		    WidthOfScreen(scrn) / 2,
		    HeightOfScreen(scrn) / 2);

    if (d->pingInterval)
    {
    	pingTimeout = XtAppAddTimeOut (context, d->pingInterval * 60 * 1000,
				       GreetPingServer, (XtPointer) d);
    }
    return dpy;
}

CloseGreet (d)
struct display	*d;
{
    Boolean	    allow;
    Arg	    arglist[1];

    if (pingTimeout)
    {
	XtRemoveTimeOut (pingTimeout);
	pingTimeout = 0;
    }
    UnsecureDisplay (d, XtDisplay (toplevel));
    XtSetArg (arglist[0], XtNallowAccess, (char *) &allow);
    XtGetValues (login, arglist, 1);
    if (allow)
    {
	Debug ("Disabling access control\n");
	XSetAccessControl (XtDisplay (toplevel), DisableAccess);
    }
    XtDestroyWidget (toplevel);
    ClearCloseOnFork (ConnectionNumber (XtDisplay (toplevel)));
    XCloseDisplay (XtDisplay (toplevel));
    Debug ("Greet connection closed\n");
}

Greet (d, greet)
struct display		*d;
struct greet_info	*greet;
{
    XEvent		event;
    Arg		arglist[1];

    XtSetArg (arglist[0], XtNallowAccess, False);
    XtSetValues (login, arglist, 1);

    Debug ("dispatching %s\n", d->name);
    done = 0;
    while (!done) {
	    XtAppNextEvent (context, &event);
	    XtDispatchEvent (&event);
    }
    XFlush (XtDisplay (toplevel));
    Debug ("Done dispatch %s\n", d->name);
    if (code == 0)
    {
	greet->name = name;
	greet->password = password;
	XtSetArg (arglist[0], XtNsessionArgument, (char *) &(greet->string));
	XtGetValues (login, arglist, 1);
	Debug ("sessionArgument: %s\n", greet->string ? greet->string : "<NULL>");
    }
    return code;
}


/*ARGSUSED*/
FailedLogin (d, greet)
struct display	*d;
struct greet_info	*greet;
{
    DrawFail (login);
}
