/*------------------------------ libXO.h -------------------------------*/

/*
 *  header for libXO
 *
 *  Author:  Miles O'Neal
 *
 *  Release: 1.0 meo - FCS release
 *
 *  COPYRIGHT 1990, 1991, Miles O'Neal, Austin, TX
 * (originally Systems & Software Solutions, Inc, Marietta, GA)
 *  Permission is hereby granted to use, copy, modify and/or distribute
 *  this software and supporting documentation, for any purpose and
 *  without fee, as long as this copyright notice and disclaimer are
 *  included in all such copies and derived works, and as long as
 *  neither the author's nor the copyright holder's name are used
 *  in publicity or distribution of said software and/or documentation
 *  without prior, written permission.
 *
 *  This software is presented as is, with no warranties expressed or
 *  implied, including implied warranties of merchantability and
 *  fitness. In no event shall the author be liable for any special,
 *  direct, indirect or consequential damages whatsoever resulting
 *  from loss of use, data or profits, whether in an action of
 *  contract, negligence or other tortious action, arising out of
 *  or in connection with the use or performance of this software.
 *  In other words, you are on your own. If you don't like it, don't
 *  use it!
 */

#ifndef __LIBXO_H__
#define __LIBXO_H__ 1

#ifndef __NO_X__
#include <X11/IntrinsicP.h>
#endif /* __NO_X__ */

int XONormalizeColorName(
#if NeedFunctionPrototypes

char *color		/* unnormalized color name */

#endif
);



/*
 * flags for colors to get and how to order them
 */

#define SHOW_GRAY	1
#define SHOW_NUMS	(1 << 1)
#define ORDER_ALPHA	(1 << 2)
#define ORDER_ASIS	(1 << 3)

int XOGetStdColorNames(
#if NeedFunctionPrototypes

char *colors[],		/* array to hold normalized color names */
int maxcolors,		/* # of elements in colors */
int *maxlen,		/* max # of chars in a normalized name */
int flags,		/* flags OR'd together */
char *namefile		/* file from which to read color names */

#endif
);



#ifndef __NO_X__

Widget XOCreateHelpBtn(
#if NeedFunctionPrototypes

Widget	parent,		/* parent of help button widget */
Widget	root,		/* root of help button widget */
void	(*cb) (),	/* user-supplied callback (if any) */
Arg	*res,		/* additional resources (if any) */
int	nres,		/* # of additional resources (if any) */
char	*helpText	/* user-supplied help text (they'd better!) */

#endif
);



int
XOAddIconToWidget(
#if NeedFunctionPrototypes

Widget w,		/* shellClass or other class that takes iconBitmap */
char *bits,		/* xbm format _bits variable name */
int width,		/* xbm format _width field */
int height		/* xbm format _height field */

#endif
);



Widget
XOCreateCancelBtn(
#if NeedFunctionPrototypes

Widget	parent,		/* parent widget of cancel button widget */
Widget	root,		/* root widget of cancel button widget */
void	(*cb) (),	/* user-supplied callback (if any) */
Arg	*res,		/* additional resources (if any) */
int	nres		/* # of additional resources (if any) */

#endif
);



Widget
XOCreateQuitBtn(
#if NeedFunctionPrototypes

Widget	parent,		/* parent widget of quit button widget */
Widget	root,		/* root widget of quit button widget */
void	(*cb) (),	/* user-supplied callback (if any) */
Arg	*res,		/* additional resources (if any) */
int	nres		/* # of additional resources (if any) */

#endif
);

#endif /* __NO_X__ */


char *XOMalloc(
#if NeedFunctionPrototypes

int n

#endif
);

void XOError(
#if NeedFunctionPrototypes

char *s

#endif
);

void XOWarning(
#if NeedFunctionPrototypes

char *s

#endif
);


#endif /* __LIBXO_H__ */
